<?php /*Template Name: teacher */ ?>
<?php get_header(); ?>


<section class="content  ">
    <div class="container">

        <h1 class="sec-tit text-center">
            <?php the_title(); ?>
        </h1>

        <div class="page-main">
            <!-- Start Teachers -->
            <?php
            $instructors = get_users(
                array(
                    // 'role' => 'editor',
                    'number' => '6',
                    'meta_query' => array(
                        'relation' => 'AND', /* <-- here */
                        array(
                            'key' => 'user_status',
                            'value' => 'active',
                            'compare' => '=='
                        ),
                        array(
                            'key' => 'user_membership',
                            'value' => 'instructor',
                            'compare' => '=='
                        )
                    )
                )
            );
            // Array of WP_User objects.
            $instructorCount = count($instructors);
            if ($instructorCount) : ?>
                <div class="row">
                    <?php foreach ($instructors as $instructor) : ?>
                        <div class="col-lg-3 col-6 mb-4">

                            <div class="instructor-member text-center">
                                <a href="<?php echo get_page_link(105); ?>?&ui=<?php echo $instructor->ID; ?>"
                                   title="<?php echo get_the_author_meta('first_name', $instructor->ID) . " " . get_the_author_meta('last_name', $instructor->ID); ?>">
                                    <?php
                                    //$user_id = get_the_author_meta($instructor->ID);
                                    @$local_avatars = get_user_meta($instructor->ID, 'basic_user_avatar', true);
                                    if (@$local_avatars['full']) {
                                        $img = @$local_avatars['full'];
                                    } else {
	                                    $img = THEME_IMAGES_DIR . 'avatar.png';
                                    }
                                    ?>
                                   <div class="instructor-img">
                                       <img class="img-fluid" src="<?php echo $img; ?>">
                                   </div>
                                    <div class="instructor-content">
                                        <h4 class="instructor-name">
                                            <?php echo get_the_author_meta('first_name', $instructor->ID) . " " . get_the_author_meta('last_name', $instructor->ID); ?>
                                        </h4>
                                    </div>
                                </a>
                            </div>

                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
            <!-- End Teachers -->
        </div>

    </div>
</section>

<?php get_footer(); ?>
